/*
 * Decompiled with CFR 0.152.
 */
package dev.codenmore.tilegame.states;

import dev.codenmore.tilegame.Handler;
import dev.codenmore.tilegame.entities.creatures.GameStateHelper;
import dev.codenmore.tilegame.entities.creatures.Health;
import dev.codenmore.tilegame.entities.creatures.Player;
import dev.codenmore.tilegame.entities.creatures.Player2;
import dev.codenmore.tilegame.states.State;
import dev.codenmore.tilegame.worlds.World;
import java.awt.Graphics;

public class GameState
extends State {
    private int roundTime;
    private int newRoundTime;
    private int round;
    private int playerwins;
    private int player2wins;
    private Player player;
    private Player2 player2;
    private Health health;
    private GameStateHelper gameStateHelper;
    private World world;
    Graphics g;
    private String oldMap = "world2";
    private String map = "world2";
    private int t = 0;
    int q = 0;

    public GameState(Handler handler, Graphics g) {
        super(handler);
        if (this.map.equals("world")) {
            this.world = new World(handler, "res/worlds/world.txt");
        }
        if (this.map.equals("world2")) {
            this.world = new World(handler, "res/worlds/world2.txt");
        }
        if (this.map.equals("world3")) {
            this.world = new World(handler, "res/worlds/world3.txt");
        }
        handler.setWorld(this.world);
        this.round = 1;
        this.playerwins = 0;
        this.player2wins = 0;
        this.roundTime += 60;
        this.newRoundTime += 60;
        this.player = new Player(handler, handler.getWorld().getSpawnX() * 64, handler.getWorld().getSpawnY() * 64, g);
        this.player2 = new Player2(handler, handler.getWorld().getSpawnX2() * 64, handler.getWorld().getSpawnY2() * 64);
        this.health = new Health(handler, handler.getWorld().getSpawnX3() * 64, handler.getWorld().getSpawnY3() * 64, g);
        this.gameStateHelper = new GameStateHelper(handler, handler.getWorld().getSpawnX3() * 64, handler.getWorld().getSpawnY3() * 64, g);
        this.g = g;
    }

    @Override
    public void tick() {
        if (!this.oldMap.equals(this.map)) {
            this.setWorld();
        }
        ++this.t;
        this.world.tick();
        this.player.tick();
        this.player2.tick();
        this.health.tick();
        this.gameStateHelper.tick();
    }

    @Override
    public void render(Graphics g) {
        this.world.render(g, this.player, this.player2);
        this.player.render(g);
        this.player2.render(g);
        this.health.render(g);
        this.gameStateHelper.render(g);
    }

    public int getT() {
        return this.t;
    }

    public void setT(int t) {
        this.t = t;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Player2 getPlayer2() {
        return this.player2;
    }

    public String getRound() {
        return Integer.toString(this.round);
    }

    public void setRound(int round) {
        this.round = round;
    }

    public int getPlayerWins() {
        return this.playerwins;
    }

    public void setPlayerwins(int playerwins) {
        this.playerwins = playerwins;
    }

    public int getPlayer2Wins() {
        return this.player2wins;
    }

    public void setPlayer2wins(int player2wins) {
        this.player2wins = player2wins;
    }

    public void setRoundTime(int roundTime) {
        this.roundTime = roundTime;
    }

    public void endRound() {
        if (this.player.getHealth() == 0 && this.player2.getHealth() == 0) {
            this.player.setHealth(100);
            this.player2.setHealth(100);
            this.round += 0;
            this.setRoundTime(60);
        } else if (this.player.getHealth() <= 0) {
            ++this.player2wins;
            this.getPlayer2Wins();
            this.player.setHealth(100);
            this.player2.setHealth(100);
            ++this.round;
            this.setRoundTime(60);
        } else if (this.player2.getHealth() <= 0) {
            ++this.playerwins;
            this.getPlayerWins();
            this.player.setHealth(100);
            this.player2.setHealth(100);
            ++this.round;
            this.setRoundTime(60);
        } else if (this.player.getHealth() > this.player2.getHealth()) {
            ++this.playerwins;
            this.getPlayerWins();
            this.player.setHealth(100);
            this.player2.setHealth(100);
            ++this.round;
            this.setRoundTime(60);
        } else if (this.player.getHealth() == this.player2.getHealth()) {
            this.player.setHealth(100);
            this.player2.setHealth(100);
            this.round += 0;
            this.setRoundTime(60);
        } else {
            ++this.player2wins;
            this.getPlayer2Wins();
            this.player.setHealth(100);
            this.player2.setHealth(100);
            ++this.round;
            this.setRoundTime(60);
        }
        this.player.setX(this.handler.getWorld().getSpawnX() * 64);
        this.player.setY(this.handler.getWorld().getSpawnY() * 64);
        this.player2.setX(this.handler.getWorld().getSpawnX2() * 64);
        this.player2.setY(this.handler.getWorld().getSpawnY2() * 64);
    }

    private void setWorld() {
        if (this.map.equals("world")) {
            this.world = new World(this.handler, "res/worlds/world.txt");
        }
        if (this.map.equals("world2")) {
            this.world = new World(this.handler, "res/worlds/world2.txt");
        }
        if (this.map.equals("world3")) {
            this.world = new World(this.handler, "res/worlds/world3.txt");
        }
        this.handler.setWorld(this.world);
        this.player.setX(this.handler.getWorld().getSpawnX() * 64);
        this.player.setY(this.handler.getWorld().getSpawnY() * 64);
        this.player2.setX(this.handler.getWorld().getSpawnX2() * 64);
        this.player2.setY(this.handler.getWorld().getSpawnY2() * 64);
        this.oldMap = this.map;
    }

    public void setMap(String str) {
        this.map = str;
    }
}

